/*
 * AbstractReaderWriter.java
 *
 * Created on October 25, 2004, 11:14 AM
 */

/**
 *
 * @author  garbi
 */
public abstract class AbstractReaderWriter implements ReaderWriter {
    protected int actRead= 0;
    protected int waitRead= 0;
    protected int actWrite= 0;
    protected int waitWrite= 0;
    
    protected abstract boolean readingPossible();
    protected abstract boolean writingPossible();
    
    public synchronized void startRead() throws InterruptedException {
        waitRead++;
        while ( !readingPossible() ) wait();
        waitRead--; actRead++;        
    }
    
    public synchronized void endRead() {
        actRead--; notifyAll();
    }
    
    public synchronized void startWrite() throws InterruptedException {
        waitWrite++;
        while ( !writingPossible() ) wait();
        waitWrite--; actWrite++;
    }
    
    public synchronized void endWrite() {
        actWrite--; notifyAll();
    }
}
